import { View, Dimensions, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
const { width } = Dimensions.get("window");

const RenderItem = ({ item }) => {
    return (
        <View style={styles.itemCont}>
            <SkeletonElement
                wrapperStyle={styles.skeletonWrapperStyle1}
            />
            <SkeletonElement
                wrapperStyle={styles.skeletonWrapper(12, 100)}
            />
            <SkeletonElement
                wrapperStyle={styles.skeletonWrapper(12, 130)}
            />
        </View>
    );
};

const FeatureProductSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5, 6]}
            keyExtractor={(_, i) => "key" + i}
            renderItem={({ item }) => <RenderItem item={item} />}
            showsVerticalScrollIndicator={false}
            numColumns={2}
            columnWrapperStyle={styles.columnWrapper}
        />
    );
};

export default FeatureProductSkeleton;

const styles = StyleSheet.create({
    itemCont: {
        marginBottom: dpr(20),
    },
    columnWrapper: {
        justifyContent: "space-between",
    },
    skeletonWrapperStyle1: {
        width: width / 2 - dpr(30),
        height: width / 2 - dpr(30),
    },
    skeletonWrapper: (height, width) => ({
        height: dpr(height),
        width: dpr(width),
    })
});
